{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 22.03.99 - 15:52:01 $                                        =}
{========================================================================}
unit CDCopy;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Buttons,
  ComCtrls,
  ExtCtrls,
  MMSystem,
  MMUtils,
  MMObj,
  MMHTimer,
  MMTrigg,
  MMGauge,
  MMCDRead,
  MMCDATyp, ImgList;

type
  TCopyDlg = class(TForm)
    Label1: TLabel;
    lblTime1: TLabel;
    Timer: TMMHiTimer;
    Meter1: TMMGauge;
    Bevel1: TBevel;
    Label2: TLabel;
    lblPercent1: TLabel;
    lblRemaining1: TLabel;
    Label3: TLabel;
    lblTime2: TLabel;
    Meter2: TMMGauge;
    Label6: TLabel;
    lblPercent2: TLabel;
    Label8: TLabel;
    lblRemaining2: TLabel;
    Label10: TLabel;
    lblSpeed1: TLabel;
    Label11: TLabel;
    Label4: TLabel;
    lblSpeed2: TLabel;
    Label9: TLabel;
    btnAbort: TButton;
    Panel1: TPanel;
    Messages: TMemo;
    Timer2: TTimer;
    ImageList: TImageList;
    procedure btnAbortClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Timer2Timer(Sender: TObject);
  public
    StartTime : Longint;
    FullTime  : Longint;
    LastTime  : Longint;
    CurTrack  : Longint;
    Writing   : Boolean;
    CurImage  : integer;

    UserAbort : Boolean;
    ErrorAbort: Boolean;
    FileName  : TFileName;

    procedure StartCopy;
    function  FindNextTrack: integer;
    procedure CopyTrack(Track: integer);
    procedure UpdateStatus;
    procedure StartTimer;
    procedure StopTimer;
  end;

var
   CopyDlg: TCopyDlg;

implementation

uses CDMain;

{$R *.DFM}

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.FormCreate(Sender: TObject);
begin
   ImageList.ResourceLoad(rtBitmap, 'BM_DRIVE1', clNone);
   ImageList.ResourceLoad(rtBitmap, 'BM_DRIVE2', clNone);

   ImageList.ResourceLoad(rtBitmap, 'BM_CD1', clNone);
   ImageList.ResourceLoad(rtBitmap, 'BM_CD2', clNone);
   ImageList.ResourceLoad(rtBitmap, 'BM_CD3', clNone);
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.FormShow(Sender: TObject);
var
   maxFrames,i: integer;
begin
   with CDMainForm, CDMainForm.CDReader do
   begin
      Messages.Clear;
      btnAbort.Caption := 'Cancel';
      UserAbort := False;
      ErrorAbort:= False;
      CurImage  := 0;
      Fulltime  := 0;
      maxFrames := 0;
      CurTrack  := -1;
      for i := 0 to ListBox.Items.Count-1 do
      begin
         if ListBox.Selected[i] and (Tracks[i].TrackType = ttAudio) then
         begin
            inc(MaxFrames,MSFToFrame(Tracks[i].Length));
            if (CurTrack = -1) then CurTrack := i;
         end;
      end;
      if (CurTrack = -1) then
      begin
         CurTrack  := Max(ListBox.ItemIndex,0);
         maxFrames := MSFToFrame(Tracks[CurTrack].Length);
      end;
      Meter2.MinValue := 0;
      Meter2.MaxValue := maxFrames;
      Meter2.Progress := 0;
   end;
   Timer2.Enabled := True;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   if (trOpen in CDMainForm.Trigger.State) then
   begin
      UserAbort := True;
      CDMainForm.Trigger.Stop;
      CanClose := False;
   end
   else CanClose := True;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.StartCopy;
begin
   CopyTrack(CurTrack);
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.CopyTrack(Track: integer);
var
   i: integer;
   S: string;
begin
   with CDMainForm, CDMainForm.CDReader do
   begin
      SetCopyParams(Tracks[Track].Start, Tracks[Track].Length);

      Meter1.MinValue := 0;
      Meter1.MaxValue := MSFToFrame(Tracks[Track].Length);
      Meter1.Progress := 0;

      CurTrack := Track;

      i := Pos('.',FileName);
      if (i > 0) then
         S := System.Copy(FileName,1,i-1)
      else
         S := FileName;

      S := S + Format('%.2d.wav',[CurTrack+1]);
      DeleteFile(S);
      CDMainForm.WaveFile.Wave.FileName := S;

      try
         Trigger.Start;
      except
         Trigger.Stop;
         raise;
      end;

      Messages.Lines.Add(Format('Copying Track %02d',[CurTrack+1]));
   end;
end;

{-- TCopyDlg ------------------------------------------------------------------}
function TCopyDlg.FindNextTrack: integer;
var
   i: integer;

begin
   with CDMainForm, CDMainForm.CDReader do
   begin
      Result := CurTrack;
      for i := 0 to ListBox.Items.Count-1 do
      begin
         if ListBox.Selected[i] and (Tracks[i].TrackType = ttAudio) then
         begin
            if (i > Result) then
            begin
               Result := i;
               break;
            end;
         end;
      end;
   end;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.btnAbortClick(Sender: TObject);
begin
   if (trOpen in CDMainForm.Trigger.State) then
   begin
      UserAbort := True;
      CDMainForm.Trigger.Stop;
   end
   else Close;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.UpdateStatus;
var
   CurTime,CurFrame: Longint;
begin
   with CDMainForm do
   begin
      CurTime              := TimeGetTime-StartTime;
      FullTime             := FullTime+(CurTime-LastTime);
      LastTime             := CurTime;

      CurFrame             := CDReader.CurrentFrame-CDReader.StartFrame;
      Meter2.Progress      := Meter2.Progress + (CurFrame-Meter1.Progress);
      Meter1.Progress      := CurFrame;

      lblPercent1.Caption  := Format('%.1f %%',[(Meter1.Progress*100)/Meter1.MaxValue]);
      lblSpeed1.Caption    := Format('%.1f X',[((Meter1.Progress*FRAME_SIZE)/(CurTime/1000))/SINGLE_SPEED]);
      lblTime1.Caption     := TimeToString(CurTime);
      lblRemaining1.Caption:= TimeToString(MulDiv(CurTime,Meter1.MaxValue,Meter1.Progress)-CurTime);

      lblPercent2.Caption  := Format('%.1f %%',[(Meter2.Progress*100)/Meter2.MaxValue]);
      lblSpeed2.Caption    := Format('%.1f X',[((Meter2.Progress*FRAME_SIZE)/(FullTime/1000))/SINGLE_SPEED]);
      lblTime2.Caption     := TimeToString(FullTime);
      lblRemaining2.Caption:= TimeToString(MulDiv(FullTime,Meter2.MaxValue,Meter2.Progress)-FullTime);
   end;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.StartTimer;
begin
   StartTime := TimeGetTime;
   LastTime  := 0;
   Timer.Enabled := True;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.StopTimer;
begin
   Timer.Enabled := False;
   if not ErrorAbort then
   begin
      Meter1.Progress := Meter1.MaxValue;
      Meter1.Update;
      lblPercent1.Caption := '100.0 %';
      lblPercent1.Update;
      lblRemaining1.Caption := TimeToString(0);
      lblRemaining1.Update;
   end;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.TimerTimer(Sender: TObject);
begin
   if Timer.Enabled then UpdateStatus;
end;

{-- TCopyDlg ------------------------------------------------------------------}
procedure TCopyDlg.Timer2Timer(Sender: TObject);
begin
   Timer2.Enabled := False;
   StartCopy;
end;

end.
